@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationTomcatConfigV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contextPath The path.
 * @property maxThreads The maximum number of connections in the connection pool.
 * @property port The port.
 * @property uriEncoding The URI encoding scheme in the Tomcat container.
 * @property useBodyEncodingForUri Specifies whether to use the encoding scheme that is specified by BodyEncoding for URL.
 */
public data class ApplicationTomcatConfigV2Args(
    public val contextPath: Output<String>? = null,
    public val maxThreads: Output<Int>? = null,
    public val port: Output<Int>? = null,
    public val uriEncoding: Output<String>? = null,
    public val useBodyEncodingForUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationTomcatConfigV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationTomcatConfigV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationTomcatConfigV2Args.builder()
            .contextPath(contextPath?.applyValue({ args0 -> args0 }))
            .maxThreads(maxThreads?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .uriEncoding(uriEncoding?.applyValue({ args0 -> args0 }))
            .useBodyEncodingForUri(useBodyEncodingForUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationTomcatConfigV2Args].
 */
@PulumiTagMarker
public class ApplicationTomcatConfigV2ArgsBuilder internal constructor() {
    private var contextPath: Output<String>? = null

    private var maxThreads: Output<Int>? = null

    private var port: Output<Int>? = null

    private var uriEncoding: Output<String>? = null

    private var useBodyEncodingForUri: Output<String>? = null

    /**
     * @param value The path.
     */
    @JvmName("oafnhjuhfnivewaf")
    public suspend fun contextPath(`value`: Output<String>) {
        this.contextPath = value
    }

    /**
     * @param value The maximum number of connections in the connection pool.
     */
    @JvmName("lkscehlewfkvvcju")
    public suspend fun maxThreads(`value`: Output<Int>) {
        this.maxThreads = value
    }

    /**
     * @param value The port.
     */
    @JvmName("ointocjcctgpjxgn")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The URI encoding scheme in the Tomcat container.
     */
    @JvmName("lqbhklcxcrewgwhv")
    public suspend fun uriEncoding(`value`: Output<String>) {
        this.uriEncoding = value
    }

    /**
     * @param value Specifies whether to use the encoding scheme that is specified by BodyEncoding for URL.
     */
    @JvmName("wqestffeipndxtcb")
    public suspend fun useBodyEncodingForUri(`value`: Output<String>) {
        this.useBodyEncodingForUri = value
    }

    /**
     * @param value The path.
     */
    @JvmName("vehoffqardjqhmjs")
    public suspend fun contextPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextPath = mapped
    }

    /**
     * @param value The maximum number of connections in the connection pool.
     */
    @JvmName("uoninncmogjbwofo")
    public suspend fun maxThreads(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxThreads = mapped
    }

    /**
     * @param value The port.
     */
    @JvmName("ctstlcgcxpmiostr")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The URI encoding scheme in the Tomcat container.
     */
    @JvmName("svlpkimgqnorbebg")
    public suspend fun uriEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriEncoding = mapped
    }

    /**
     * @param value Specifies whether to use the encoding scheme that is specified by BodyEncoding for URL.
     */
    @JvmName("oranbirwndocyged")
    public suspend fun useBodyEncodingForUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useBodyEncodingForUri = mapped
    }

    internal fun build(): ApplicationTomcatConfigV2Args = ApplicationTomcatConfigV2Args(
        contextPath = contextPath,
        maxThreads = maxThreads,
        port = port,
        uriEncoding = uriEncoding,
        useBodyEncodingForUri = useBodyEncodingForUri,
    )
}
