@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchUpdate The phased release policy. See `batch_update` below.
 * @property type The type of the release policy. Valid values: `GrayBatchUpdate` and `BatchUpdate`.
 */
public data class ApplicationUpdateStrategyV2Args(
    public val batchUpdate: Output<ApplicationUpdateStrategyV2BatchUpdateArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2Args.builder()
            .batchUpdate(batchUpdate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationUpdateStrategyV2Args].
 */
@PulumiTagMarker
public class ApplicationUpdateStrategyV2ArgsBuilder internal constructor() {
    private var batchUpdate: Output<ApplicationUpdateStrategyV2BatchUpdateArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The phased release policy. See `batch_update` below.
     */
    @JvmName("xrekaratrocxyhge")
    public suspend fun batchUpdate(`value`: Output<ApplicationUpdateStrategyV2BatchUpdateArgs>) {
        this.batchUpdate = value
    }

    /**
     * @param value The type of the release policy. Valid values: `GrayBatchUpdate` and `BatchUpdate`.
     */
    @JvmName("dynyxfaxtpwliwkr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The phased release policy. See `batch_update` below.
     */
    @JvmName("mbeqysnfhnobfdhy")
    public suspend fun batchUpdate(`value`: ApplicationUpdateStrategyV2BatchUpdateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchUpdate = mapped
    }

    /**
     * @param argument The phased release policy. See `batch_update` below.
     */
    @JvmName("ygkncwtbannddohh")
    public suspend fun batchUpdate(argument: suspend ApplicationUpdateStrategyV2BatchUpdateArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationUpdateStrategyV2BatchUpdateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.batchUpdate = mapped
    }

    /**
     * @param value The type of the release policy. Valid values: `GrayBatchUpdate` and `BatchUpdate`.
     */
    @JvmName("qnuhkoplgdmbdhkq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ApplicationUpdateStrategyV2Args = ApplicationUpdateStrategyV2Args(
        batchUpdate = batchUpdate,
        type = type,
    )
}
