@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2BatchUpdateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batch The number of batches in which you want to release the instances.
 * @property batchWaitTime The batch wait time.
 * @property releaseType The processing method for the batches. Valid values: `auto` and `manual`.
 */
public data class ApplicationUpdateStrategyV2BatchUpdateArgs(
    public val batch: Output<Int>? = null,
    public val batchWaitTime: Output<Int>? = null,
    public val releaseType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2BatchUpdateArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2BatchUpdateArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationUpdateStrategyV2BatchUpdateArgs.builder()
            .batch(batch?.applyValue({ args0 -> args0 }))
            .batchWaitTime(batchWaitTime?.applyValue({ args0 -> args0 }))
            .releaseType(releaseType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationUpdateStrategyV2BatchUpdateArgs].
 */
@PulumiTagMarker
public class ApplicationUpdateStrategyV2BatchUpdateArgsBuilder internal constructor() {
    private var batch: Output<Int>? = null

    private var batchWaitTime: Output<Int>? = null

    private var releaseType: Output<String>? = null

    /**
     * @param value The number of batches in which you want to release the instances.
     */
    @JvmName("bgfjlcmvccqwnhvo")
    public suspend fun batch(`value`: Output<Int>) {
        this.batch = value
    }

    /**
     * @param value The batch wait time.
     */
    @JvmName("libdkiosdifibmad")
    public suspend fun batchWaitTime(`value`: Output<Int>) {
        this.batchWaitTime = value
    }

    /**
     * @param value The processing method for the batches. Valid values: `auto` and `manual`.
     */
    @JvmName("kgxtlusffttaeuwd")
    public suspend fun releaseType(`value`: Output<String>) {
        this.releaseType = value
    }

    /**
     * @param value The number of batches in which you want to release the instances.
     */
    @JvmName("vygfjimaswmmnaeu")
    public suspend fun batch(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batch = mapped
    }

    /**
     * @param value The batch wait time.
     */
    @JvmName("ierbvwiyrmxpsqfs")
    public suspend fun batchWaitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchWaitTime = mapped
    }

    /**
     * @param value The processing method for the batches. Valid values: `auto` and `manual`.
     */
    @JvmName("poydxufohgoujsmf")
    public suspend fun releaseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseType = mapped
    }

    internal fun build(): ApplicationUpdateStrategyV2BatchUpdateArgs =
        ApplicationUpdateStrategyV2BatchUpdateArgs(
            batch = batch,
            batchWaitTime = batchWaitTime,
            releaseType = releaseType,
        )
}
