@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GetApplicationScalingRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplicationScalingRules.
 * @property appId The ID of the Application.
 * @property ids A list of Application Scaling Rule IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetApplicationScalingRulesPlainArgs(
    public val appId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GetApplicationScalingRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GetApplicationScalingRulesPlainArgs =
        com.pulumi.alicloud.sae.inputs.GetApplicationScalingRulesPlainArgs.builder()
            .appId(appId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationScalingRulesPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationScalingRulesPlainArgsBuilder internal constructor() {
    private var appId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the Application.
     */
    @JvmName("eefcoifidqduewja")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appId = mapped
    }

    /**
     * @param value A list of Application Scaling Rule IDs.
     */
    @JvmName("xxrstjotvjyuxyru")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Application Scaling Rule IDs.
     */
    @JvmName("bbdgvjeyhobufqsd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("eoxjhawctrfgyfvb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetApplicationScalingRulesPlainArgs = GetApplicationScalingRulesPlainArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
        ids = ids,
        outputFile = outputFile,
    )
}
