@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GetApplicationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplications.
 * @property appName Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property fieldType The field type. Valid values:`appName`, `appIds`, `slbIps`, `instanceIps`
 * @property fieldValue The field value.
 * @property ids A list of Application IDs.
 * @property namespaceId SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
 * @property orderBy The order by.Valid values:`running`,`instances`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property reverse The reverse.
 * @property status The status of the resource. Valid values: `RUNNING`, `STOPPED`,`UNKNOWN`.
 */
public data class GetApplicationsPlainArgs(
    public val appName: String? = null,
    public val enableDetails: Boolean? = null,
    public val fieldType: String? = null,
    public val fieldValue: String? = null,
    public val ids: List<String>? = null,
    public val namespaceId: String? = null,
    public val orderBy: String? = null,
    public val outputFile: String? = null,
    public val reverse: Boolean? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GetApplicationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GetApplicationsPlainArgs =
        com.pulumi.alicloud.sae.inputs.GetApplicationsPlainArgs.builder()
            .appName(appName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .fieldType(fieldType?.let({ args0 -> args0 }))
            .fieldValue(fieldValue?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .namespaceId(namespaceId?.let({ args0 -> args0 }))
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .reverse(reverse?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationsPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationsPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var enableDetails: Boolean? = null

    private var fieldType: String? = null

    private var fieldValue: String? = null

    private var ids: List<String>? = null

    private var namespaceId: String? = null

    private var orderBy: String? = null

    private var outputFile: String? = null

    private var reverse: Boolean? = null

    private var status: String? = null

    /**
     * @param value Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
     */
    @JvmName("ookqfgwbxkexugff")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("ktjiutcqigklqqmp")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The field type. Valid values:`appName`, `appIds`, `slbIps`, `instanceIps`
     */
    @JvmName("iqdodmuyjfijncmj")
    public suspend fun fieldType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fieldType = mapped
    }

    /**
     * @param value The field value.
     */
    @JvmName("upalstdasaspjlse")
    public suspend fun fieldValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fieldValue = mapped
    }

    /**
     * @param value A list of Application IDs.
     */
    @JvmName("qigwwkjimregbasw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Application IDs.
     */
    @JvmName("qsjgyklyjhslqaif")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
     */
    @JvmName("bjvdtbqnrnbgruvm")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespaceId = mapped
    }

    /**
     * @param value The order by.Valid values:`running`,`instances`.
     */
    @JvmName("fhwhptxiabloitnt")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("btvfkucfnmwhpciu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The reverse.
     */
    @JvmName("bvciraxulhfajmrw")
    public suspend fun reverse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.reverse = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `RUNNING`, `STOPPED`,`UNKNOWN`.
     */
    @JvmName("ovqforapiumktsmo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetApplicationsPlainArgs = GetApplicationsPlainArgs(
        appName = appName,
        enableDetails = enableDetails,
        fieldType = fieldType,
        fieldValue = fieldValue,
        ids = ids,
        namespaceId = namespaceId,
        orderBy = orderBy,
        outputFile = outputFile,
        reverse = reverse,
        status = status,
    )
}
