@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GetConfigMapsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfigMaps.
 * @property ids A list of Config Map IDs.
 * @property nameRegex A regex string to filter results by Config Map name.
 * @property namespaceId The NamespaceId of Config Maps. The Id of Namespace.It can contain 2 to 32 characters.The value is in format {RegionId}:{namespace}.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetConfigMapsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val namespaceId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GetConfigMapsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GetConfigMapsPlainArgs =
        com.pulumi.alicloud.sae.inputs.GetConfigMapsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .namespaceId(namespaceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigMapsPlainArgs].
 */
@PulumiTagMarker
public class GetConfigMapsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var namespaceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Config Map IDs.
     */
    @JvmName("anxdidrdqwclxscn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Config Map IDs.
     */
    @JvmName("xyjbuwsenocwriwa")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Config Map name.
     */
    @JvmName("maceqkaegsjomosx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The NamespaceId of Config Maps. The Id of Namespace.It can contain 2 to 32 characters.The value is in format {RegionId}:{namespace}.
     */
    @JvmName("ychyostypycknxry")
    public suspend fun namespaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bphgtmkvrychxoey")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetConfigMapsPlainArgs = GetConfigMapsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        namespaceId = namespaceId ?: throw PulumiNullFieldException("namespaceId"),
        outputFile = outputFile,
    )
}
