@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GetGreyTagRoutesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGreyTagRoutes.
 * @property appId The ID  of the SAE Application.
 * @property ids A list of GreyTagRoute IDs.
 * @property nameRegex A regex string to filter results by GreyTagRoute name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetGreyTagRoutesPlainArgs(
    public val appId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GetGreyTagRoutesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GetGreyTagRoutesPlainArgs =
        com.pulumi.alicloud.sae.inputs.GetGreyTagRoutesPlainArgs.builder()
            .appId(appId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGreyTagRoutesPlainArgs].
 */
@PulumiTagMarker
public class GetGreyTagRoutesPlainArgsBuilder internal constructor() {
    private var appId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID  of the SAE Application.
     */
    @JvmName("dlvthpqtoplfvvog")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appId = mapped
    }

    /**
     * @param value A list of GreyTagRoute IDs.
     */
    @JvmName("mntjybkjllctgroj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of GreyTagRoute IDs.
     */
    @JvmName("fqqajybdygreilap")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by GreyTagRoute name.
     */
    @JvmName("wylepgfktfqqmkwx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("imkfialfqyhugsoy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetGreyTagRoutesPlainArgs = GetGreyTagRoutesPlainArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
