@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GetInstanceSpecificationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceSpecifications.
 * @property ids A list of Instance Specification IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetInstanceSpecificationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GetInstanceSpecificationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GetInstanceSpecificationsPlainArgs =
        com.pulumi.alicloud.sae.inputs.GetInstanceSpecificationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceSpecificationsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceSpecificationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Instance Specification IDs.
     */
    @JvmName("eoussgdyknlccfay")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Instance Specification IDs.
     */
    @JvmName("rfykbcyqsqweuadv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qqcftclfrmweeumb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstanceSpecificationsPlainArgs = GetInstanceSpecificationsPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
