@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GreyTagRouteDubboRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property condition The Conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
 * @property group The service group.
 * @property items A list of conditions items. See `items` below.
 * @property methodName The method name
 * @property serviceName The service name.
 * @property version The service version.
 */
public data class GreyTagRouteDubboRuleArgs(
    public val condition: Output<String>? = null,
    public val group: Output<String>? = null,
    public val items: Output<List<GreyTagRouteDubboRuleItemArgs>>? = null,
    public val methodName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GreyTagRouteDubboRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GreyTagRouteDubboRuleArgs =
        com.pulumi.alicloud.sae.inputs.GreyTagRouteDubboRuleArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .methodName(methodName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GreyTagRouteDubboRuleArgs].
 */
@PulumiTagMarker
public class GreyTagRouteDubboRuleArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var group: Output<String>? = null

    private var items: Output<List<GreyTagRouteDubboRuleItemArgs>>? = null

    private var methodName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The Conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
     */
    @JvmName("fnivyanmuwxqrlpv")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value The service group.
     */
    @JvmName("ytgygeurdbciptrv")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value A list of conditions items. See `items` below.
     */
    @JvmName("kjxuoplskthnxlle")
    public suspend fun items(`value`: Output<List<GreyTagRouteDubboRuleItemArgs>>) {
        this.items = value
    }

    @JvmName("umajjfnkdkqjnhfi")
    public suspend fun items(vararg values: Output<GreyTagRouteDubboRuleItemArgs>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values A list of conditions items. See `items` below.
     */
    @JvmName("rivykermfjmdxkcs")
    public suspend fun items(values: List<Output<GreyTagRouteDubboRuleItemArgs>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value The method name
     */
    @JvmName("uipofgmcbifogfwt")
    public suspend fun methodName(`value`: Output<String>) {
        this.methodName = value
    }

    /**
     * @param value The service name.
     */
    @JvmName("qlkwvsnuxxoogcxf")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The service version.
     */
    @JvmName("tqobfgalqclfiyji")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The Conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
     */
    @JvmName("fpchfcekqlbrysyb")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value The service group.
     */
    @JvmName("spuioxhmdbywaqgp")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value A list of conditions items. See `items` below.
     */
    @JvmName("eqkinypphcpomgst")
    public suspend fun items(`value`: List<GreyTagRouteDubboRuleItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument A list of conditions items. See `items` below.
     */
    @JvmName("kxsyoejkfndpvkfm")
    public suspend fun items(argument: List<suspend GreyTagRouteDubboRuleItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GreyTagRouteDubboRuleItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument A list of conditions items. See `items` below.
     */
    @JvmName("fslucoeivtalvvbj")
    public suspend fun items(vararg argument: suspend GreyTagRouteDubboRuleItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GreyTagRouteDubboRuleItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument A list of conditions items. See `items` below.
     */
    @JvmName("qanoionpaahabges")
    public suspend fun items(argument: suspend GreyTagRouteDubboRuleItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GreyTagRouteDubboRuleItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param values A list of conditions items. See `items` below.
     */
    @JvmName("diiykjqqhagjyjfb")
    public suspend fun items(vararg values: GreyTagRouteDubboRuleItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value The method name
     */
    @JvmName("odynedvuvmpwayxf")
    public suspend fun methodName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methodName = mapped
    }

    /**
     * @param value The service name.
     */
    @JvmName("kkhfevkksigjwanv")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The service version.
     */
    @JvmName("abkpjbhcptgancjo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GreyTagRouteDubboRuleArgs = GreyTagRouteDubboRuleArgs(
        condition = condition,
        group = group,
        items = items,
        methodName = methodName,
        serviceName = serviceName,
        version = version,
    )
}
