@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.GreyTagRouteScRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property condition The conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
 * @property items A list of conditions items. See `items` below.
 * @property path The path corresponding to the grayscale rule.
 */
public data class GreyTagRouteScRuleArgs(
    public val condition: Output<String>? = null,
    public val items: Output<List<GreyTagRouteScRuleItemArgs>>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.GreyTagRouteScRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.GreyTagRouteScRuleArgs =
        com.pulumi.alicloud.sae.inputs.GreyTagRouteScRuleArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GreyTagRouteScRuleArgs].
 */
@PulumiTagMarker
public class GreyTagRouteScRuleArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var items: Output<List<GreyTagRouteScRuleItemArgs>>? = null

    private var path: Output<String>? = null

    /**
     * @param value The conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
     */
    @JvmName("xsyhpnvpjnbcmjdd")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value A list of conditions items. See `items` below.
     */
    @JvmName("biutcquvfaxccswg")
    public suspend fun items(`value`: Output<List<GreyTagRouteScRuleItemArgs>>) {
        this.items = value
    }

    @JvmName("oapobavipbfcfbjr")
    public suspend fun items(vararg values: Output<GreyTagRouteScRuleItemArgs>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values A list of conditions items. See `items` below.
     */
    @JvmName("ivrceikvgupybymq")
    public suspend fun items(values: List<Output<GreyTagRouteScRuleItemArgs>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value The path corresponding to the grayscale rule.
     */
    @JvmName("hptaslolaeklqhyx")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
     */
    @JvmName("bpradfpaodlbnhyc")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value A list of conditions items. See `items` below.
     */
    @JvmName("swinlgapndurotbl")
    public suspend fun items(`value`: List<GreyTagRouteScRuleItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument A list of conditions items. See `items` below.
     */
    @JvmName("mjcmpnpiavxpouwg")
    public suspend fun items(argument: List<suspend GreyTagRouteScRuleItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GreyTagRouteScRuleItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument A list of conditions items. See `items` below.
     */
    @JvmName("dgebeypswfbypmdc")
    public suspend fun items(vararg argument: suspend GreyTagRouteScRuleItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GreyTagRouteScRuleItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument A list of conditions items. See `items` below.
     */
    @JvmName("bhsawsupdfjibvpl")
    public suspend fun items(argument: suspend GreyTagRouteScRuleItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GreyTagRouteScRuleItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param values A list of conditions items. See `items` below.
     */
    @JvmName("jvdeqhoksakfanus")
    public suspend fun items(vararg values: GreyTagRouteScRuleItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value The path corresponding to the grayscale rule.
     */
    @JvmName("eqxwxrydchkwlmlk")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): GreyTagRouteScRuleArgs = GreyTagRouteScRuleArgs(
        condition = condition,
        items = items,
        path = path,
    )
}
