@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.IngressDefaultRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appId Target application ID.
 * @property appName Target application name.
 * @property containerPort Application backend port.
 */
public data class IngressDefaultRuleArgs(
    public val appId: Output<String>? = null,
    public val appName: Output<String>? = null,
    public val containerPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.IngressDefaultRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.IngressDefaultRuleArgs =
        com.pulumi.alicloud.sae.inputs.IngressDefaultRuleArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appName(appName?.applyValue({ args0 -> args0 }))
            .containerPort(containerPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngressDefaultRuleArgs].
 */
@PulumiTagMarker
public class IngressDefaultRuleArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appName: Output<String>? = null

    private var containerPort: Output<Int>? = null

    /**
     * @param value Target application ID.
     */
    @JvmName("bswkxokugynxbuwx")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Target application name.
     */
    @JvmName("qlieckwvkxqqltgv")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Application backend port.
     */
    @JvmName("tkjwecbvvgipgdoe")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value Target application ID.
     */
    @JvmName("avafoxhvyxloplbe")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Target application name.
     */
    @JvmName("shwdoskwyiorbnfn")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Application backend port.
     */
    @JvmName("vaxpowecygcbpdbo")
    public suspend fun containerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    internal fun build(): IngressDefaultRuleArgs = IngressDefaultRuleArgs(
        appId = appId,
        appName = appName,
        containerPort = containerPort,
    )
}
