@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.IngressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appId Target application ID.
 * @property appName Target application name.
 * @property backendProtocol The backend protocol.
 * @property containerPort Application backend port.
 * @property domain Application domain name.
 * @property path URL path.
 * @property rewritePath The rewrite path.
 */
public data class IngressRuleArgs(
    public val appId: Output<String>,
    public val appName: Output<String>,
    public val backendProtocol: Output<String>? = null,
    public val containerPort: Output<Int>,
    public val domain: Output<String>,
    public val path: Output<String>,
    public val rewritePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.IngressRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.IngressRuleArgs =
        com.pulumi.alicloud.sae.inputs.IngressRuleArgs.builder()
            .appId(appId.applyValue({ args0 -> args0 }))
            .appName(appName.applyValue({ args0 -> args0 }))
            .backendProtocol(backendProtocol?.applyValue({ args0 -> args0 }))
            .containerPort(containerPort.applyValue({ args0 -> args0 }))
            .domain(domain.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .rewritePath(rewritePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngressRuleArgs].
 */
@PulumiTagMarker
public class IngressRuleArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appName: Output<String>? = null

    private var backendProtocol: Output<String>? = null

    private var containerPort: Output<Int>? = null

    private var domain: Output<String>? = null

    private var path: Output<String>? = null

    private var rewritePath: Output<String>? = null

    /**
     * @param value Target application ID.
     */
    @JvmName("avxamuwkdmpfrspl")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Target application name.
     */
    @JvmName("qquuigokrjdjpiyq")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The backend protocol.
     */
    @JvmName("uexfjimqivimnwtq")
    public suspend fun backendProtocol(`value`: Output<String>) {
        this.backendProtocol = value
    }

    /**
     * @param value Application backend port.
     */
    @JvmName("tciivlcsxkylrgyw")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value Application domain name.
     */
    @JvmName("yfyxpnywllppuqqt")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value URL path.
     */
    @JvmName("abcthefctlqfqrmt")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The rewrite path.
     */
    @JvmName("yggyugjexvdtrdtn")
    public suspend fun rewritePath(`value`: Output<String>) {
        this.rewritePath = value
    }

    /**
     * @param value Target application ID.
     */
    @JvmName("nnswuvrxxkhejsfr")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Target application name.
     */
    @JvmName("wphhaftvotsxgksu")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The backend protocol.
     */
    @JvmName("nrwvbxnnvdwgicub")
    public suspend fun backendProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendProtocol = mapped
    }

    /**
     * @param value Application backend port.
     */
    @JvmName("vschgdqshbchgiwo")
    public suspend fun containerPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    /**
     * @param value Application domain name.
     */
    @JvmName("njknieekhlhbuwxb")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value URL path.
     */
    @JvmName("hyvkggtkbpworuyw")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The rewrite path.
     */
    @JvmName("ljewajeimscjktqa")
    public suspend fun rewritePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewritePath = mapped
    }

    internal fun build(): IngressRuleArgs = IngressRuleArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
        appName = appName ?: throw PulumiNullFieldException("appName"),
        backendProtocol = backendProtocol,
        containerPort = containerPort ?: throw PulumiNullFieldException("containerPort"),
        domain = domain ?: throw PulumiNullFieldException("domain"),
        path = path ?: throw PulumiNullFieldException("path"),
        rewritePath = rewritePath,
    )
}
