@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.LoadBalancerInternetInternetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpsCertId The SSL certificate. `https_cert_id` is required when HTTPS is selected
 * @property port The SLB Port.
 * @property protocol The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
 * @property targetPort The Container port.
 */
public data class LoadBalancerInternetInternetArgs(
    public val httpsCertId: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val targetPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.LoadBalancerInternetInternetArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.LoadBalancerInternetInternetArgs =
        com.pulumi.alicloud.sae.inputs.LoadBalancerInternetInternetArgs.builder()
            .httpsCertId(httpsCertId?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .targetPort(targetPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerInternetInternetArgs].
 */
@PulumiTagMarker
public class LoadBalancerInternetInternetArgsBuilder internal constructor() {
    private var httpsCertId: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var targetPort: Output<Int>? = null

    /**
     * @param value The SSL certificate. `https_cert_id` is required when HTTPS is selected
     */
    @JvmName("xdpjbucqliwfktie")
    public suspend fun httpsCertId(`value`: Output<String>) {
        this.httpsCertId = value
    }

    /**
     * @param value The SLB Port.
     */
    @JvmName("anxgreqacymutuvu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
     */
    @JvmName("lqboiffipfxqeluo")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The Container port.
     */
    @JvmName("bcnvmyqmwccnucmn")
    public suspend fun targetPort(`value`: Output<Int>) {
        this.targetPort = value
    }

    /**
     * @param value The SSL certificate. `https_cert_id` is required when HTTPS is selected
     */
    @JvmName("mpuassnefsffsyft")
    public suspend fun httpsCertId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsCertId = mapped
    }

    /**
     * @param value The SLB Port.
     */
    @JvmName("kpvyrpbxqmqbwbhv")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
     */
    @JvmName("jcijvqnahppvstfb")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The Container port.
     */
    @JvmName("xearxjlryxneggrt")
    public suspend fun targetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    internal fun build(): LoadBalancerInternetInternetArgs = LoadBalancerInternetInternetArgs(
        httpsCertId = httpsCertId,
        port = port,
        protocol = protocol,
        targetPort = targetPort,
    )
}
