@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.LoadBalancerIntranetIntranetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpsCertId The SSL certificate. `https_cert_id` is required when HTTPS is selected
 * @property port The SLB Port.
 * @property protocol The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
 * @property targetPort The Container port.
 */
public data class LoadBalancerIntranetIntranetArgs(
    public val httpsCertId: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val targetPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.LoadBalancerIntranetIntranetArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.LoadBalancerIntranetIntranetArgs =
        com.pulumi.alicloud.sae.inputs.LoadBalancerIntranetIntranetArgs.builder()
            .httpsCertId(httpsCertId?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .targetPort(targetPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerIntranetIntranetArgs].
 */
@PulumiTagMarker
public class LoadBalancerIntranetIntranetArgsBuilder internal constructor() {
    private var httpsCertId: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var targetPort: Output<Int>? = null

    /**
     * @param value The SSL certificate. `https_cert_id` is required when HTTPS is selected
     */
    @JvmName("ulveicufnfhsnpmm")
    public suspend fun httpsCertId(`value`: Output<String>) {
        this.httpsCertId = value
    }

    /**
     * @param value The SLB Port.
     */
    @JvmName("vqywrsxmiwtaqkri")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
     */
    @JvmName("qyymjtcrvvygvwom")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The Container port.
     */
    @JvmName("qwmevlfoqvqifxwa")
    public suspend fun targetPort(`value`: Output<Int>) {
        this.targetPort = value
    }

    /**
     * @param value The SSL certificate. `https_cert_id` is required when HTTPS is selected
     */
    @JvmName("tkdsxuvlxrmsrfxd")
    public suspend fun httpsCertId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsCertId = mapped
    }

    /**
     * @param value The SLB Port.
     */
    @JvmName("wwjhanuktmtuegxg")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
     */
    @JvmName("uoetxtkwfxepmgok")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The Container port.
     */
    @JvmName("iowbhbjtpixhagme")
    public suspend fun targetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    internal fun build(): LoadBalancerIntranetIntranetArgs = LoadBalancerIntranetIntranetArgs(
        httpsCertId = httpsCertId,
        port = port,
        protocol = protocol,
        targetPort = targetPort,
    )
}
