@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property kafkaConfigs One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
 * @property kafkaEndpoint The endpoint of the ApsaraMQ for Kafka API.
 * @property kafkaInstanceId The  ID of the ApsaraMQ for Kafka instance.
 */
public data class ApplicationKafkaConfigs(
    public val kafkaConfigs: List<ApplicationKafkaConfigsKafkaConfig>? = null,
    public val kafkaEndpoint: String? = null,
    public val kafkaInstanceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationKafkaConfigs): ApplicationKafkaConfigs = ApplicationKafkaConfigs(
            kafkaConfigs = javaType.kafkaConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationKafkaConfigsKafkaConfig.Companion.toKotlin(args0)
                })
            }),
            kafkaEndpoint = javaType.kafkaEndpoint().map({ args0 -> args0 }).orElse(null),
            kafkaInstanceId = javaType.kafkaInstanceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
