@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kafkaTopic The topic of the Kafka.
 * @property logDir The path in which logs are stored.
 * @property logType The type of the log.
 */
public data class ApplicationKafkaConfigsKafkaConfig(
    public val kafkaTopic: String? = null,
    public val logDir: String? = null,
    public val logType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationKafkaConfigsKafkaConfig): ApplicationKafkaConfigsKafkaConfig = ApplicationKafkaConfigsKafkaConfig(
            kafkaTopic = javaType.kafkaTopic().map({ args0 -> args0 }).orElse(null),
            logDir = javaType.logDir().map({ args0 -> args0 }).orElse(null),
            logType = javaType.logType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
