@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mountDomain The domain name of the mount target.
 * @property mountPath The mount path of the container.
 * @property nasId The ID of the NAS file system.
 * @property nasPath The directory in the NAS file system.
 * @property readOnly Specifies whether the application can read data from or write data to resources in the directory of the NAS. Valid values: `true` and `false`. If you set `read_only` to `false`, the application has the read and write permissions.
 */
public data class ApplicationNasConfig(
    public val mountDomain: String? = null,
    public val mountPath: String? = null,
    public val nasId: String? = null,
    public val nasPath: String? = null,
    public val readOnly: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationNasConfig): ApplicationNasConfig = ApplicationNasConfig(
            mountDomain = javaType.mountDomain().map({ args0 -> args0 }).orElse(null),
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            nasId = javaType.nasId().map({ args0 -> args0 }).orElse(null),
            nasPath = javaType.nasPath().map({ args0 -> args0 }).orElse(null),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
