@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of the OSS bucket.
 * @property bucketPath The directory or object in OSS.
 * @property mountPath The path of the container in SAE.
 * @property readOnly Specifies whether the application can use the container path to read data from or write data to resources in the directory of the OSS bucket. Valid values:
 */
public data class ApplicationOssMountDescsV2(
    public val bucketName: String? = null,
    public val bucketPath: String? = null,
    public val mountPath: String? = null,
    public val readOnly: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationOssMountDescsV2): ApplicationOssMountDescsV2 = ApplicationOssMountDescsV2(
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            bucketPath = javaType.bucketPath().map({ args0 -> args0 }).orElse(null),
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
