@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enable Enables the Kubernetes Service-based registration and discovery feature.
 * @property namespaceId The ID of the namespace.
 * @property portProtocols The port number and protocol. See `port_protocols` below.
 * @property serviceName The name of the Service.
 */
public data class ApplicationPvtzDiscoverySvc(
    public val enable: Boolean? = null,
    public val namespaceId: String? = null,
    public val portProtocols: List<ApplicationPvtzDiscoverySvcPortProtocol>? = null,
    public val serviceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationPvtzDiscoverySvc): ApplicationPvtzDiscoverySvc = ApplicationPvtzDiscoverySvc(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            namespaceId = javaType.namespaceId().map({ args0 -> args0 }).orElse(null),
            portProtocols = javaType.portProtocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPvtzDiscoverySvcPortProtocol.Companion.toKotlin(args0)
                })
            }),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
