@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property exec Execute. See `exec` below.
 * @property httpGet The liveness check settings of the container. See `http_get` below.
 * @property initialDelaySeconds The delay of the health check.
 * @property periodSeconds The interval at which the health check is performed.
 * @property tcpSocket The liveness check settings of the container. See `tcp_socket` below.
 * @property timeoutSeconds The timeout period of the health check.
 */
public data class ApplicationReadinessV2(
    public val exec: ApplicationReadinessV2Exec? = null,
    public val httpGet: ApplicationReadinessV2HttpGet? = null,
    public val initialDelaySeconds: Int? = null,
    public val periodSeconds: Int? = null,
    public val tcpSocket: ApplicationReadinessV2TcpSocket? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationReadinessV2): ApplicationReadinessV2 = ApplicationReadinessV2(
            exec = javaType.exec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationReadinessV2Exec.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpGet = javaType.httpGet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationReadinessV2HttpGet.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialDelaySeconds = javaType.initialDelaySeconds().map({ args0 -> args0 }).orElse(null),
            periodSeconds = javaType.periodSeconds().map({ args0 -> args0 }).orElse(null),
            tcpSocket = javaType.tcpSocket().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationReadinessV2TcpSocket.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
