@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property maxReplicas Maximum number of instances applied.
 * @property metrics Indicator rule configuration. See `metrics` below.
 * @property minReplicas Minimum number of instances applied.
 * @property scaleDownRules Apply shrink rules. See `scale_down_rules` below.
 * @property scaleUpRules Apply expansion rules. See `scale_up_rules` below.
 */
public data class ApplicationScalingRuleScalingRuleMetric(
    public val maxReplicas: Int? = null,
    public val metrics: List<ApplicationScalingRuleScalingRuleMetricMetric>? = null,
    public val minReplicas: Int? = null,
    public val scaleDownRules: ApplicationScalingRuleScalingRuleMetricScaleDownRules? = null,
    public val scaleUpRules: ApplicationScalingRuleScalingRuleMetricScaleUpRules? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationScalingRuleScalingRuleMetric): ApplicationScalingRuleScalingRuleMetric = ApplicationScalingRuleScalingRuleMetric(
            maxReplicas = javaType.maxReplicas().map({ args0 -> args0 }).orElse(null),
            metrics = javaType.metrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationScalingRuleScalingRuleMetricMetric.Companion.toKotlin(args0)
                })
            }),
            minReplicas = javaType.minReplicas().map({ args0 -> args0 }).orElse(null),
            scaleDownRules = javaType.scaleDownRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationScalingRuleScalingRuleMetricScaleDownRules.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scaleUpRules = javaType.scaleUpRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationScalingRuleScalingRuleMetricScaleUpRules.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
