@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metricTargetAverageUtilization According to different `metric_type`, set the target value of the corresponding monitoring index.
 * @property metricType Monitoring indicator trigger condition. Valid values: `CPU`, `MEMORY`, `tcpActiveConn`, `QPS`, `RT`, `SLB_QPS`, `SLB_RT`, `INTRANET_SLB_QPS` and `INTRANET_SLB_RT`. The values are described as follows:
 * - CPU: CPU usage.
 * - MEMORY: MEMORY usage.
 * - tcpActiveConn: The average number of TCP active connections for a single instance in 30 seconds.
 * - QPS: The average QPS of a single instance within 1 minute of JAVA application.
 * - RT: The average response time of all service interfaces within 1 minute of JAVA application.
 * - SLB_QPS: The average public network SLB QPS of a single instance within 15 seconds.
 * - SLB_RT: The average response time of public network SLB within 15 seconds.
 * - INTRANET_SLB_QPS: The average private network SLB QPS of a single instance within 15 seconds.
 * - INTRANET_SLB_RT: The average response time of private network SLB within 15 seconds.
 * **NOTE:** From version 1.206.0, `metric_type` can be set to `QPS`, `RT`, `INTRANET_SLB_QPS`, `INTRANET_SLB_RT`.
 * @property slbId SLB ID.
 * @property slbLogStore The log store of the Log Service.
 * @property slbProject The project of the Log Service.
 * @property vport SLB listening port.
 */
public data class ApplicationScalingRuleScalingRuleMetricMetric(
    public val metricTargetAverageUtilization: Int? = null,
    public val metricType: String? = null,
    public val slbId: String? = null,
    public val slbLogStore: String? = null,
    public val slbProject: String? = null,
    public val vport: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationScalingRuleScalingRuleMetricMetric): ApplicationScalingRuleScalingRuleMetricMetric =
            ApplicationScalingRuleScalingRuleMetricMetric(
                metricTargetAverageUtilization = javaType.metricTargetAverageUtilization().map({ args0 ->
                    args0
                }).orElse(null),
                metricType = javaType.metricType().map({ args0 -> args0 }).orElse(null),
                slbId = javaType.slbId().map({ args0 -> args0 }).orElse(null),
                slbLogStore = javaType.slbLogStore().map({ args0 -> args0 }).orElse(null),
                slbProject = javaType.slbProject().map({ args0 -> args0 }).orElse(null),
                vport = javaType.vport().map({ args0 -> args0 }).orElse(null),
            )
    }
}
