@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property disabled Whether shrinkage is prohibited.
 * @property stabilizationWindowSeconds Cooling time for expansion or contraction. Valid values: `0` to `3600`. Unit: seconds. The default is `0` seconds.
 * @property step Elastic expansion or contraction step size. the maximum number of instances to be scaled in per unit time.
 */
public data class ApplicationScalingRuleScalingRuleMetricScaleDownRules(
    public val disabled: Boolean? = null,
    public val stabilizationWindowSeconds: Int? = null,
    public val step: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationScalingRuleScalingRuleMetricScaleDownRules): ApplicationScalingRuleScalingRuleMetricScaleDownRules =
            ApplicationScalingRuleScalingRuleMetricScaleDownRules(
                disabled = javaType.disabled().map({ args0 -> args0 }).orElse(null),
                stabilizationWindowSeconds = javaType.stabilizationWindowSeconds().map({ args0 ->
                    args0
                }).orElse(null),
                step = javaType.step().map({ args0 -> args0 }).orElse(null),
            )
    }
}
