@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property beginDate The Start date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
 * @property endDate The End Date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
 * @property period The period in which a timed elastic scaling strategy is executed.
 * @property schedules Resilient Scaling Strategy Trigger Timing. See `schedules` below.
 */
public data class ApplicationScalingRuleScalingRuleTimer(
    public val beginDate: String? = null,
    public val endDate: String? = null,
    public val period: String? = null,
    public val schedules: List<ApplicationScalingRuleScalingRuleTimerSchedule>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationScalingRuleScalingRuleTimer): ApplicationScalingRuleScalingRuleTimer = ApplicationScalingRuleScalingRuleTimer(
            beginDate = javaType.beginDate().map({ args0 -> args0 }).orElse(null),
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            schedules = javaType.schedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.ApplicationScalingRuleScalingRuleTimerSchedule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
