@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contextPath The path.
 * @property maxThreads The maximum number of connections in the connection pool.
 * @property port The port.
 * @property uriEncoding The URI encoding scheme in the Tomcat container.
 * @property useBodyEncodingForUri Specifies whether to use the encoding scheme that is specified by BodyEncoding for URL.
 */
public data class ApplicationTomcatConfigV2(
    public val contextPath: String? = null,
    public val maxThreads: Int? = null,
    public val port: Int? = null,
    public val uriEncoding: String? = null,
    public val useBodyEncodingForUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationTomcatConfigV2): ApplicationTomcatConfigV2 = ApplicationTomcatConfigV2(
            contextPath = javaType.contextPath().map({ args0 -> args0 }).orElse(null),
            maxThreads = javaType.maxThreads().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            uriEncoding = javaType.uriEncoding().map({ args0 -> args0 }).orElse(null),
            useBodyEncodingForUri = javaType.useBodyEncodingForUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
