@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batch The number of batches in which you want to release the instances.
 * @property batchWaitTime The batch wait time.
 * @property releaseType The processing method for the batches. Valid values: `auto` and `manual`.
 */
public data class ApplicationUpdateStrategyV2BatchUpdate(
    public val batch: Int? = null,
    public val batchWaitTime: Int? = null,
    public val releaseType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.ApplicationUpdateStrategyV2BatchUpdate): ApplicationUpdateStrategyV2BatchUpdate = ApplicationUpdateStrategyV2BatchUpdate(
            batch = javaType.batch().map({ args0 -> args0 }).orElse(null),
            batchWaitTime = javaType.batchWaitTime().map({ args0 -> args0 }).orElse(null),
            releaseType = javaType.releaseType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
