@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appId The ID of the Application.
 * @property createTime The CreateTime of the Application Scaling Rule.
 * @property id The ID of the Application Scaling Rule.
 * @property scalingRuleEnable Whether to enable the auto scaling policy.
 * @property scalingRuleMetrics Monitoring indicators for elastic scaling.
 * @property scalingRuleName The name of the scaling rule.
 * @property scalingRuleTimers Timing elastic expansion.
 * @property scalingRuleType Flexible strategy type.
 */
public data class GetApplicationScalingRulesRule(
    public val appId: String,
    public val createTime: String,
    public val id: String,
    public val scalingRuleEnable: Boolean,
    public val scalingRuleMetrics: List<GetApplicationScalingRulesRuleScalingRuleMetric>,
    public val scalingRuleName: String,
    public val scalingRuleTimers: List<GetApplicationScalingRulesRuleScalingRuleTimer>,
    public val scalingRuleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationScalingRulesRule): GetApplicationScalingRulesRule = GetApplicationScalingRulesRule(
            appId = javaType.appId(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            scalingRuleEnable = javaType.scalingRuleEnable(),
            scalingRuleMetrics = javaType.scalingRuleMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetric.Companion.toKotlin(args0)
                })
            }),
            scalingRuleName = javaType.scalingRuleName(),
            scalingRuleTimers = javaType.scalingRuleTimers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleTimer.Companion.toKotlin(args0)
                })
            }),
            scalingRuleType = javaType.scalingRuleType(),
        )
    }
}
