@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property maxReplicas The maximum number of instances.
 * @property metrics The auto scaling list of monitoring indicators.
 * @property metricsStatuses Monitor indicator elasticity status.
 * @property minReplicas The minimum number of instances.
 * @property scaleDownRules The shrink rule.
 * @property scaleUpRules The expansion rules.
 */
public data class GetApplicationScalingRulesRuleScalingRuleMetric(
    public val maxReplicas: Int,
    public val metrics: List<GetApplicationScalingRulesRuleScalingRuleMetricMetric>,
    public val metricsStatuses: List<GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatus>,
    public val minReplicas: Int,
    public val scaleDownRules: List<GetApplicationScalingRulesRuleScalingRuleMetricScaleDownRule>,
    public val scaleUpRules: List<GetApplicationScalingRulesRuleScalingRuleMetricScaleUpRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationScalingRulesRuleScalingRuleMetric): GetApplicationScalingRulesRuleScalingRuleMetric =
            GetApplicationScalingRulesRuleScalingRuleMetric(
                maxReplicas = javaType.maxReplicas(),
                metrics = javaType.metrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetricMetric.Companion.toKotlin(args0)
                    })
                }),
                metricsStatuses = javaType.metricsStatuses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatus.Companion.toKotlin(args0)
                    })
                }),
                minReplicas = javaType.minReplicas(),
                scaleDownRules = javaType.scaleDownRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetricScaleDownRule.Companion.toKotlin(args0)
                    })
                }),
                scaleUpRules = javaType.scaleUpRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetricScaleUpRule.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
