@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property currentMetrics The current monitoring indicator elasticity list.
 * @property currentReplicas The number of current instances.
 * @property desiredReplicas The number of target instances.
 * @property lastScaleTime The time of the last elastic expansion.
 * @property maxReplicas The maximum number of instances.
 * @property minReplicas The minimum number of instances.
 * @property nextScaleMetrics Next monitoring indicator elasticity list
 * @property nextScaleTimePeriod The next cycle of monitoring indicator elasticity.
 */
public data class GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatus(
    public val currentMetrics: List<GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatusCurrentMetric>,
    public val currentReplicas: Int,
    public val desiredReplicas: Int,
    public val lastScaleTime: String,
    public val maxReplicas: Int,
    public val minReplicas: Int,
    public val nextScaleMetrics: List<GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatusNextScaleMetric>,
    public val nextScaleTimePeriod: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatus): GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatus =
            GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatus(
                currentMetrics = javaType.currentMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatusCurrentMetric.Companion.toKotlin(args0)
                    })
                }),
                currentReplicas = javaType.currentReplicas(),
                desiredReplicas = javaType.desiredReplicas(),
                lastScaleTime = javaType.lastScaleTime(),
                maxReplicas = javaType.maxReplicas(),
                minReplicas = javaType.minReplicas(),
                nextScaleMetrics = javaType.nextScaleMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleMetricMetricsStatusNextScaleMetric.Companion.toKotlin(args0)
                    })
                }),
                nextScaleTimePeriod = javaType.nextScaleTimePeriod(),
            )
    }
}
