@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property beginDate The short-term start date of the timed elastic scaling strategy.
 * @property endDate The short-term end date of the timed elastic scaling strategy.
 * @property period The period in which a timed elastic scaling strategy is executed.
 * @property schedules Trigger point in time within a single day.
 */
public data class GetApplicationScalingRulesRuleScalingRuleTimer(
    public val beginDate: String,
    public val endDate: String,
    public val period: String,
    public val schedules: List<GetApplicationScalingRulesRuleScalingRuleTimerSchedule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationScalingRulesRuleScalingRuleTimer): GetApplicationScalingRulesRuleScalingRuleTimer =
            GetApplicationScalingRulesRuleScalingRuleTimer(
                beginDate = javaType.beginDate(),
                endDate = javaType.endDate(),
                period = javaType.period(),
                schedules = javaType.schedules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesRuleScalingRuleTimerSchedule.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
