@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property acrAssumeRoleArn The ARN of the RAM role required when pulling images across accounts.
 * @property acrInstanceId The ID of the ACR EE instance.
 * @property appDescription Application description information. No more than 1024 characters.
 * @property appName Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
 * @property applicationId The first ID of the resource.
 * @property command Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
 * @property commandArgs Mirror startup command parameters. The parameters required for the above start command. For example: 1d.
 * @property configMapMountDesc ConfigMap mount description.
 * @property cpu The CPU required for each instance, in millicores, cannot be 0.
 * @property createTime Indicates That the Application of the Creation Time.
 * @property customHostAlias Custom host mapping in the container. For example: [{"hostName":"samplehost","ip":"127&#46;0&#46;0&#46;1"}].
 * @property edasContainerVersion The operating environment used by the Pandora application.
 * @property envs The virtual switch where the elastic network card of the application instance is located. The switch must be located in the aforementioned VPC. The switch also has a binding relationship with the SAE namespace. If it is left blank, the default is the vSwitch ID bound to the namespace.
 * @property id The ID of the Application.
 * @property imageUrl Mirror address. Only Image type applications can configure the mirror address.
 * @property jarStartArgs The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
 * @property jarStartOptions The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
 * @property jdk The JDK version that the deployment package depends on. Image type applications are not supported.
 * @property liveness Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
 * @property memory The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU.
 * @property minReadyInstances The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
 * @property mountDescs Mount description information.
 * @property mountHost Mount point of NAS in application VPC.
 * @property namespaceId SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
 * @property nasId ID of the mounted NAS, Must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field is present, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
 * @property ossAkId OSS AccessKey ID.
 * @property ossAkSecret OSS  AccessKey Secret.
 * @property ossMountDescs OSS mount description information.
 * @property ossMountDetails The OSS mount detail.
 * @property packageType Application package type. Support FatJar, War and Image.
 * @property packageUrl Deployment package address. Only FatJar or War type applications can configure the deployment package address.
 * @property packageVersion The version number of the deployment package. Required when the Package Type is War and FatJar.
 * @property phpArmsConfigLocation The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
 * @property phpConfig PHP configuration file content.
 * @property phpConfigLocation PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
 * @property postStart Execute the script after startup, the format is like: {"exec":{"command":["cat","/etc/group"]}}.
 * @property preStop Execute the script before stopping, the format is like: {"exec":{"command":["cat","/etc/group"]}}.
 * @property readiness Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {"exec":{"command":["sh","-c","cat /home/admin/start&#46;sh"]},"initialDelaySeconds":30,"periodSeconds":30,"timeoutSeconds ":2}.
 * @property regionId
 * @property replicas Initial number of instances.
 * @property repoName
 * @property repoNamespace
 * @property repoOriginType
 * @property securityGroupId Security group ID.
 * @property slsConfigs SLS  configuration.
 * @property status The status of the resource.
 * @property tags A mapping of tags to assign to the resource.
 * @property terminationGracePeriodSeconds Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60.
 * @property timezone Time zone, the default value is Asia/Shanghai.
 * @property tomcatConfig Tomcat file configuration, set to "" or "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL.
 * @property vpcId The VPC corresponding to the SAE namespace. In SAE, a namespace can only correspond to one VPC and cannot be modified. Creating a SAE application in the namespace for the first time will form a binding relationship. Multiple namespaces can correspond to a VPC. If you leave it blank, it will default to the VPC ID bound to the namespace.
 * @property vswitchId The vswitch id.
 * @property warStartOptions WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
 * @property webContainer The version of tomcat that the deployment package depends on. Image type applications are not supported.
 */
public data class GetApplicationsApplication(
    public val acrAssumeRoleArn: String,
    public val acrInstanceId: String,
    public val appDescription: String,
    public val appName: String,
    public val applicationId: String,
    public val command: String,
    public val commandArgs: String,
    public val configMapMountDesc: String,
    public val cpu: Int,
    public val createTime: String,
    public val customHostAlias: String,
    public val edasContainerVersion: String,
    public val envs: String,
    public val id: String,
    public val imageUrl: String,
    public val jarStartArgs: String,
    public val jarStartOptions: String,
    public val jdk: String,
    public val liveness: String,
    public val memory: Int,
    public val minReadyInstances: Int,
    public val mountDescs: List<GetApplicationsApplicationMountDesc>,
    public val mountHost: String,
    public val namespaceId: String,
    public val nasId: String,
    public val ossAkId: String,
    public val ossAkSecret: String,
    public val ossMountDescs: String,
    public val ossMountDetails: List<GetApplicationsApplicationOssMountDetail>,
    public val packageType: String,
    public val packageUrl: String,
    public val packageVersion: String,
    public val phpArmsConfigLocation: String,
    public val phpConfig: String,
    public val phpConfigLocation: String,
    public val postStart: String,
    public val preStop: String,
    public val readiness: String,
    public val regionId: String,
    public val replicas: Int,
    public val repoName: String,
    public val repoNamespace: String,
    public val repoOriginType: String,
    public val securityGroupId: String,
    public val slsConfigs: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val terminationGracePeriodSeconds: Int,
    public val timezone: String,
    public val tomcatConfig: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val warStartOptions: String,
    public val webContainer: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationsApplication): GetApplicationsApplication = GetApplicationsApplication(
            acrAssumeRoleArn = javaType.acrAssumeRoleArn(),
            acrInstanceId = javaType.acrInstanceId(),
            appDescription = javaType.appDescription(),
            appName = javaType.appName(),
            applicationId = javaType.applicationId(),
            command = javaType.command(),
            commandArgs = javaType.commandArgs(),
            configMapMountDesc = javaType.configMapMountDesc(),
            cpu = javaType.cpu(),
            createTime = javaType.createTime(),
            customHostAlias = javaType.customHostAlias(),
            edasContainerVersion = javaType.edasContainerVersion(),
            envs = javaType.envs(),
            id = javaType.id(),
            imageUrl = javaType.imageUrl(),
            jarStartArgs = javaType.jarStartArgs(),
            jarStartOptions = javaType.jarStartOptions(),
            jdk = javaType.jdk(),
            liveness = javaType.liveness(),
            memory = javaType.memory(),
            minReadyInstances = javaType.minReadyInstances(),
            mountDescs = javaType.mountDescs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationsApplicationMountDesc.Companion.toKotlin(args0)
                })
            }),
            mountHost = javaType.mountHost(),
            namespaceId = javaType.namespaceId(),
            nasId = javaType.nasId(),
            ossAkId = javaType.ossAkId(),
            ossAkSecret = javaType.ossAkSecret(),
            ossMountDescs = javaType.ossMountDescs(),
            ossMountDetails = javaType.ossMountDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationsApplicationOssMountDetail.Companion.toKotlin(args0)
                })
            }),
            packageType = javaType.packageType(),
            packageUrl = javaType.packageUrl(),
            packageVersion = javaType.packageVersion(),
            phpArmsConfigLocation = javaType.phpArmsConfigLocation(),
            phpConfig = javaType.phpConfig(),
            phpConfigLocation = javaType.phpConfigLocation(),
            postStart = javaType.postStart(),
            preStop = javaType.preStop(),
            readiness = javaType.readiness(),
            regionId = javaType.regionId(),
            replicas = javaType.replicas(),
            repoName = javaType.repoName(),
            repoNamespace = javaType.repoNamespace(),
            repoOriginType = javaType.repoOriginType(),
            securityGroupId = javaType.securityGroupId(),
            slsConfigs = javaType.slsConfigs(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            terminationGracePeriodSeconds = javaType.terminationGracePeriodSeconds(),
            timezone = javaType.timezone(),
            tomcatConfig = javaType.tomcatConfig(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            warStartOptions = javaType.warStartOptions(),
            webContainer = javaType.webContainer(),
        )
    }
}
