@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of the bucket.
 * @property bucketPath The path of the bucket.
 * @property mountPath The Container mount path.
 * @property readOnly Whether the container path has readable permission to mount directory resources.
 */
public data class GetApplicationsApplicationOssMountDetail(
    public val bucketName: String,
    public val bucketPath: String,
    public val mountPath: String,
    public val readOnly: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationsApplicationOssMountDetail): GetApplicationsApplicationOssMountDetail = GetApplicationsApplicationOssMountDetail(
            bucketName = javaType.bucketName(),
            bucketPath = javaType.bucketPath(),
            mountPath = javaType.mountPath(),
            readOnly = javaType.readOnly(),
        )
    }
}
