@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApplications.
 * @property appName
 * @property applications
 * @property enableDetails
 * @property fieldType
 * @property fieldValue
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property namespaceId
 * @property orderBy
 * @property outputFile
 * @property reverse
 * @property status
 */
public data class GetApplicationsResult(
    public val appName: String? = null,
    public val applications: List<GetApplicationsApplication>,
    public val enableDetails: Boolean? = null,
    public val fieldType: String? = null,
    public val fieldValue: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val namespaceId: String? = null,
    public val orderBy: String? = null,
    public val outputFile: String? = null,
    public val reverse: Boolean? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetApplicationsResult): GetApplicationsResult = GetApplicationsResult(
            appName = javaType.appName().map({ args0 -> args0 }).orElse(null),
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationsApplication.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            fieldType = javaType.fieldType().map({ args0 -> args0 }).orElse(null),
            fieldValue = javaType.fieldValue().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            namespaceId = javaType.namespaceId().map({ args0 -> args0 }).orElse(null),
            orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            reverse = javaType.reverse().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
