@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConfigMaps.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property maps
 * @property nameRegex
 * @property names
 * @property namespaceId
 * @property outputFile
 */
public data class GetConfigMapsResult(
    public val id: String,
    public val ids: List<String>,
    public val maps: List<GetConfigMapsMap>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespaceId: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetConfigMapsResult): GetConfigMapsResult = GetConfigMapsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            maps = javaType.maps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetConfigMapsMap.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespaceId = javaType.namespaceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
