@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description The description of GreyTagRoute.
 * @property dubboRules The grayscale rule created for Dubbo Application.
 * @property greyTagRouteName The name of GreyTagRoute.
 * @property id The ID of the GreyTagRoute.
 * @property scRules The grayscale rule created for SpringCloud Application.
 */
public data class GetGreyTagRoutesRoute(
    public val description: String,
    public val dubboRules: List<GetGreyTagRoutesRouteDubboRule>,
    public val greyTagRouteName: String,
    public val id: String,
    public val scRules: List<GetGreyTagRoutesRouteScRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetGreyTagRoutesRoute): GetGreyTagRoutesRoute = GetGreyTagRoutesRoute(
            description = javaType.description(),
            dubboRules = javaType.dubboRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetGreyTagRoutesRouteDubboRule.Companion.toKotlin(args0)
                })
            }),
            greyTagRouteName = javaType.greyTagRouteName(),
            id = javaType.id(),
            scRules = javaType.scRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetGreyTagRoutesRouteScRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
