@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property condition The conditional Patterns for Grayscale Rules.
 * @property group The service group.
 * @property items A list of conditions items.
 * @property methodName The method name
 * @property serviceName The service name.
 * @property version The service version.
 */
public data class GetGreyTagRoutesRouteDubboRule(
    public val condition: String,
    public val group: String,
    public val items: List<GetGreyTagRoutesRouteDubboRuleItem>,
    public val methodName: String,
    public val serviceName: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetGreyTagRoutesRouteDubboRule): GetGreyTagRoutesRouteDubboRule = GetGreyTagRoutesRouteDubboRule(
            condition = javaType.condition(),
            group = javaType.group(),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetGreyTagRoutesRouteDubboRuleItem.Companion.toKotlin(args0)
                })
            }),
            methodName = javaType.methodName(),
            serviceName = javaType.serviceName(),
            version = javaType.version(),
        )
    }
}
