@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property condition The Conditional Patterns for Grayscale Rules.
 * @property items A list of conditions items.
 * @property path The path corresponding to the grayscale rule.
 */
public data class GetGreyTagRoutesRouteScRule(
    public val condition: String,
    public val items: List<GetGreyTagRoutesRouteScRuleItem>,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetGreyTagRoutesRouteScRule): GetGreyTagRoutesRouteScRule = GetGreyTagRoutesRouteScRule(
            condition = javaType.condition(),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetGreyTagRoutesRouteScRuleItem.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path(),
        )
    }
}
