@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certId Cert Id.
 * @property defaultRule Default Rule.
 * @property description Description.
 * @property id The ID of the Ingress.
 * @property ingressId The first ID of the resource.
 * @property listenerPort SLB listening port.
 * @property namespaceId The Id of Namespace.It can contain 2 to 32 characters.The value is in format {RegionId}:{namespace}.
 * @property slbId SLB ID.
 */
public data class GetIngressesIngress(
    public val certId: String,
    public val defaultRule: String,
    public val description: String,
    public val id: String,
    public val ingressId: String,
    public val listenerPort: Int,
    public val namespaceId: String,
    public val slbId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetIngressesIngress): GetIngressesIngress = GetIngressesIngress(
            certId = javaType.certId(),
            defaultRule = javaType.defaultRule(),
            description = javaType.description(),
            id = javaType.id(),
            ingressId = javaType.ingressId(),
            listenerPort = javaType.listenerPort(),
            namespaceId = javaType.namespaceId(),
            slbId = javaType.slbId(),
        )
    }
}
