@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceSpecifications.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property specifications
 */
public data class GetInstanceSpecificationsResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val specifications: List<GetInstanceSpecificationsSpecification>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetInstanceSpecificationsResult): GetInstanceSpecificationsResult = GetInstanceSpecificationsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            specifications = javaType.specifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GetInstanceSpecificationsSpecification.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
