@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu CPU Size, Specifications for Micronucleus.
 * @property enable Whether the instance is available. The value description is as follows:
 * @property id The ID of the Instance Specification.
 * @property instanceSpecificationId The first ID of the resource.
 * @property memory The Memory specifications for the MB.
 * @property specInfo The specification configuration name.
 * @property version The specification configuration version.
 */
public data class GetInstanceSpecificationsSpecification(
    public val cpu: Int,
    public val enable: Boolean,
    public val id: String,
    public val instanceSpecificationId: String,
    public val memory: Int,
    public val specInfo: String,
    public val version: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GetInstanceSpecificationsSpecification): GetInstanceSpecificationsSpecification = GetInstanceSpecificationsSpecification(
            cpu = javaType.cpu(),
            enable = javaType.enable(),
            id = javaType.id(),
            instanceSpecificationId = javaType.instanceSpecificationId(),
            memory = javaType.memory(),
            specInfo = javaType.specInfo(),
            version = javaType.version(),
        )
    }
}
