@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property condition The Conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
 * @property group The service group.
 * @property items A list of conditions items. See `items` below.
 * @property methodName The method name
 * @property serviceName The service name.
 * @property version The service version.
 */
public data class GreyTagRouteDubboRule(
    public val condition: String? = null,
    public val group: String? = null,
    public val items: List<GreyTagRouteDubboRuleItem>? = null,
    public val methodName: String? = null,
    public val serviceName: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GreyTagRouteDubboRule): GreyTagRouteDubboRule = GreyTagRouteDubboRule(
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            group = javaType.group().map({ args0 -> args0 }).orElse(null),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GreyTagRouteDubboRuleItem.Companion.toKotlin(args0)
                })
            }),
            methodName = javaType.methodName().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
