@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property condition The conditional Patterns for Grayscale Rules. Valid values: `AND`, `OR`.
 * @property items A list of conditions items. See `items` below.
 * @property path The path corresponding to the grayscale rule.
 */
public data class GreyTagRouteScRule(
    public val condition: String? = null,
    public val items: List<GreyTagRouteScRuleItem>? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.GreyTagRouteScRule): GreyTagRouteScRule = GreyTagRouteScRule(
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            items = javaType.items().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sae.kotlin.outputs.GreyTagRouteScRuleItem.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
