@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appId Target application ID.
 * @property appName Target application name.
 * @property containerPort Application backend port.
 */
public data class IngressDefaultRule(
    public val appId: String? = null,
    public val appName: String? = null,
    public val containerPort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.IngressDefaultRule): IngressDefaultRule = IngressDefaultRule(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            appName = javaType.appName().map({ args0 -> args0 }).orElse(null),
            containerPort = javaType.containerPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
