@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appId Target application ID.
 * @property appName Target application name.
 * @property backendProtocol The backend protocol.
 * @property containerPort Application backend port.
 * @property domain Application domain name.
 * @property path URL path.
 * @property rewritePath The rewrite path.
 */
public data class IngressRule(
    public val appId: String,
    public val appName: String,
    public val backendProtocol: String? = null,
    public val containerPort: Int,
    public val domain: String,
    public val path: String,
    public val rewritePath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.IngressRule): IngressRule =
            IngressRule(
                appId = javaType.appId(),
                appName = javaType.appName(),
                backendProtocol = javaType.backendProtocol().map({ args0 -> args0 }).orElse(null),
                containerPort = javaType.containerPort(),
                domain = javaType.domain(),
                path = javaType.path(),
                rewritePath = javaType.rewritePath().map({ args0 -> args0 }).orElse(null),
            )
    }
}
