@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpsCertId The SSL certificate. `https_cert_id` is required when HTTPS is selected
 * @property port The SLB Port.
 * @property protocol The Network protocol. Valid values: `TCP` ,`HTTP`,`HTTPS`.
 * @property targetPort The Container port.
 */
public data class LoadBalancerIntranetIntranet(
    public val httpsCertId: String? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
    public val targetPort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sae.outputs.LoadBalancerIntranetIntranet): LoadBalancerIntranetIntranet = LoadBalancerIntranetIntranet(
            httpsCertId = javaType.httpsCertId().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            targetPort = javaType.targetPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
