@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin

import com.pulumi.alicloud.sag.SagFunctions.getAclsPlain
import com.pulumi.alicloud.sag.SagFunctions.getSmartagFlowLogsPlain
import com.pulumi.alicloud.sag.kotlin.inputs.GetAclsPlainArgs
import com.pulumi.alicloud.sag.kotlin.inputs.GetAclsPlainArgsBuilder
import com.pulumi.alicloud.sag.kotlin.inputs.GetSmartagFlowLogsPlainArgs
import com.pulumi.alicloud.sag.kotlin.inputs.GetSmartagFlowLogsPlainArgsBuilder
import com.pulumi.alicloud.sag.kotlin.outputs.GetAclsResult
import com.pulumi.alicloud.sag.kotlin.outputs.GetSmartagFlowLogsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.sag.kotlin.outputs.GetAclsResult.Companion.toKotlin as getAclsResultToKotlin
import com.pulumi.alicloud.sag.kotlin.outputs.GetSmartagFlowLogsResult.Companion.toKotlin as getSmartagFlowLogsResultToKotlin

public object SagFunctions {
    /**
     * This data source provides Sag Acls available to the user.
     * > **NOTE:** Available in 1.60.0+
     * > **NOTE:** Only the following regions support create Cloud Connect Network. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.sag.getAcls({
     *     ids: [defaultAlicloudSagAcls&#46;id],
     *     nameRegex: "^tf-testAcc.*",
     * });
     * const defaultAcl = new alicloud.rocketmq.Acl("default", {name: "tf-testAccSagAclName"});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.sag.get_acls(ids=[default_alicloud_sag_acls["id"]],
     *     name_regex="^tf-testAcc.*")
     * default_acl = alicloud.rocketmq.Acl("default", name="tf-testAccSagAclName")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Sag.GetAcls.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudSagAcls.Id,
     *         },
     *         NameRegex = "^tf-testAcc.*",
     *     });
     *     var defaultAcl = new AliCloud.RocketMQ.Acl("default", new()
     *     {
     *         Name = "tf-testAccSagAclName",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sag"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := sag.GetAcls(ctx, &sag.GetAclsArgs{
     * Ids: interface{}{
     * defaultAlicloudSagAcls.Id,
     * },
     * NameRegex: pulumi.StringRef("^tf-testAcc.*"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = rocketmq.NewAcl(ctx, "default", &rocketmq.AclArgs{
     * Name: pulumi.String("tf-testAccSagAclName"),
     * })
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sag.SagFunctions;
     * import com.pulumi.alicloud.sag.inputs.GetAclsArgs;
     * import com.pulumi.alicloud.rocketmq.Acl;
     * import com.pulumi.alicloud.rocketmq.AclArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = SagFunctions.getAcls(GetAclsArgs.builder()
     *             .ids(defaultAlicloudSagAcls.id())
     *             .nameRegex("^tf-testAcc.*")
     *             .build());
     *         var defaultAcl = new Acl("defaultAcl", AclArgs.builder()
     *             .name("tf-testAccSagAclName")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultAcl:
     *     type: alicloud:rocketmq:Acl
     *     name: default
     *     properties:
     *       name: tf-testAccSagAclName
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:sag:getAcls
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudSagAcls.id}
     *         nameRegex: ^tf-testAcc.*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAcls.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: GetAclsPlainArgs): GetAclsResult =
        getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())

    /**
     * @see [getAcls].
     * @param ids A list of Sag Acl IDs.
     * @param nameRegex A regex string to filter Sag Acl instances by name.
     * @param outputFile
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAclsResult {
        val argument = GetAclsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAcls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sag&#46;kotlin&#46;inputs&#46;GetAclsPlainArgs].
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: suspend GetAclsPlainArgsBuilder.() -> Unit): GetAclsResult {
        val builder = GetAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAclsResultToKotlin(getAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Smartag Flow Logs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.168.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.sag.getSmartagFlowLogs({
     *     ids: ["example_id"],
     * });
     * export const smartagFlowLogId1 = ids.then(ids => ids.logs?.[0]?.id);
     * const nameRegex = alicloud.sag.getSmartagFlowLogs({
     *     nameRegex: "^my-FlowLog",
     * });
     * export const smartagFlowLogId2 = nameRegex.then(nameRegex => nameRegex.logs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.sag.get_smartag_flow_logs(ids=["example_id"])
     * pulumi.export("smartagFlowLogId1", ids.logs[0].id)
     * name_regex = alicloud.sag.get_smartag_flow_logs(name_regex="^my-FlowLog")
     * pulumi.export("smartagFlowLogId2", name_regex.logs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Sag.GetSmartagFlowLogs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Sag.GetSmartagFlowLogs.Invoke(new()
     *     {
     *         NameRegex = "^my-FlowLog",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["smartagFlowLogId1"] = ids&#46;Apply(getSmartagFlowLogsResult => getSmartagFlowLogsResult&#46;Logs[0]?.Id),
     *         ["smartagFlowLogId2"] = nameRegex&#46;Apply(getSmartagFlowLogsResult => getSmartagFlowLogsResult&#46;Logs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sag"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := sag.GetSmartagFlowLogs(ctx, &sag.GetSmartagFlowLogsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("smartagFlowLogId1", ids.Logs[0].Id)
     * 		nameRegex, err := sag.GetSmartagFlowLogs(ctx, &sag.GetSmartagFlowLogsArgs{
     * 			NameRegex: pulumi.StringRef("^my-FlowLog"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("smartagFlowLogId2", nameRegex.Logs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sag.SagFunctions;
     * import com.pulumi.alicloud.sag.inputs.GetSmartagFlowLogsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SagFunctions.getSmartagFlowLogs(GetSmartagFlowLogsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("smartagFlowLogId1", ids.applyValue(getSmartagFlowLogsResult -> getSmartagFlowLogsResult.logs()[0].id()));
     *         final var nameRegex = SagFunctions.getSmartagFlowLogs(GetSmartagFlowLogsArgs.builder()
     *             .nameRegex("^my-FlowLog")
     *             .build());
     *         ctx.export("smartagFlowLogId2", nameRegex.applyValue(getSmartagFlowLogsResult -> getSmartagFlowLogsResult.logs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:sag:getSmartagFlowLogs
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:sag:getSmartagFlowLogs
     *       Arguments:
     *         nameRegex: ^my-FlowLog
     * outputs:
     *   smartagFlowLogId1: ${ids.logs[0].id}
     *   smartagFlowLogId2: ${nameRegex.logs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSmartagFlowLogs.
     * @return A collection of values returned by getSmartagFlowLogs.
     */
    public suspend fun getSmartagFlowLogs(argument: GetSmartagFlowLogsPlainArgs): GetSmartagFlowLogsResult =
        getSmartagFlowLogsResultToKotlin(getSmartagFlowLogsPlain(argument.toJava()).await())

    /**
     * @see [getSmartagFlowLogs].
     * @param description The description of the flow log.
     * @param ids A list of Flow Log IDs.
     * @param nameRegex A regex string to filter results by Flow Log name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
     * @return A collection of values returned by getSmartagFlowLogs.
     */
    public suspend fun getSmartagFlowLogs(
        description: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetSmartagFlowLogsResult {
        val argument = GetSmartagFlowLogsPlainArgs(
            description = description,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getSmartagFlowLogsResultToKotlin(getSmartagFlowLogsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSmartagFlowLogs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sag&#46;kotlin&#46;inputs&#46;GetSmartagFlowLogsPlainArgs].
     * @return A collection of values returned by getSmartagFlowLogs.
     */
    public suspend fun getSmartagFlowLogs(argument: suspend GetSmartagFlowLogsPlainArgsBuilder.() -> Unit): GetSmartagFlowLogsResult {
        val builder = GetSmartagFlowLogsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSmartagFlowLogsResultToKotlin(getSmartagFlowLogsPlain(builtArgument.toJava()).await())
    }
}
