@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SmartagFlowLog].
 */
@PulumiTagMarker
public class SmartagFlowLogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SmartagFlowLogArgs = SmartagFlowLogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SmartagFlowLogArgsBuilder.() -> Unit) {
        val builder = SmartagFlowLogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SmartagFlowLog {
        val builtJavaResource = com.pulumi.alicloud.sag.SmartagFlowLog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SmartagFlowLog(builtJavaResource)
    }
}

/**
 * Provides a Smartag Flow Log resource.
 * For information about Smartag Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createflowlog).
 * > **NOTE:** Available since v1.168.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.sag.SmartagFlowLog("example", {
 *     netflowServerIp: "192.168.0.2",
 *     netflowServerPort: 9995,
 *     netflowVersion: "V9",
 *     outputType: "netflow",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.sag.SmartagFlowLog("example",
 *     netflow_server_ip="192.168.0.2",
 *     netflow_server_port=9995,
 *     netflow_version="V9",
 *     output_type="netflow")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Sag.SmartagFlowLog("example", new()
 *     {
 *         NetflowServerIp = "192.168.0.2",
 *         NetflowServerPort = 9995,
 *         NetflowVersion = "V9",
 *         OutputType = "netflow",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sag"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sag.NewSmartagFlowLog(ctx, "example", &sag.SmartagFlowLogArgs{
 * 			NetflowServerIp:   pulumi.String("192.168.0.2"),
 * 			NetflowServerPort: pulumi.Int(9995),
 * 			NetflowVersion:    pulumi.String("V9"),
 * 			OutputType:        pulumi.String("netflow"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sag.SmartagFlowLog;
 * import com.pulumi.alicloud.sag.SmartagFlowLogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SmartagFlowLog("example", SmartagFlowLogArgs.builder()
 *             .netflowServerIp("192.168.0.2")
 *             .netflowServerPort(9995)
 *             .netflowVersion("V9")
 *             .outputType("netflow")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:sag:SmartagFlowLog
 *     properties:
 *       netflowServerIp: 192.168.0.2
 *       netflowServerPort: 9995
 *       netflowVersion: V9
 *       outputType: netflow
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Smartag Flow Log can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sag/smartagFlowLog:SmartagFlowLog example <id>
 * ```
 */
public class SmartagFlowLog internal constructor(
    override val javaResource: com.pulumi.alicloud.sag.SmartagFlowLog,
) : KotlinCustomResource(javaResource, SmartagFlowLogMapper) {
    /**
     * The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
     */
    public val activeAging: Output<Int>
        get() = javaResource.activeAging().applyValue({ args0 -> args0 })

    /**
     * The description of the flow log.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the flow log.
     */
    public val flowLogName: Output<String>?
        get() = javaResource.flowLogName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
     */
    public val inactiveAging: Output<Int>
        get() = javaResource.inactiveAging().applyValue({ args0 -> args0 })

    /**
     * The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    public val logstoreName: Output<String>?
        get() = javaResource.logstoreName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    public val netflowServerIp: Output<String>?
        get() = javaResource.netflowServerIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    public val netflowServerPort: Output<Int>
        get() = javaResource.netflowServerPort().applyValue({ args0 -> args0 })

    /**
     * The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    public val netflowVersion: Output<String>
        get() = javaResource.netflowVersion().applyValue({ args0 -> args0 })

    /**
     * The location where the flow log is stored. Valid values:
     */
    public val outputType: Output<String>
        get() = javaResource.outputType().applyValue({ args0 -> args0 })

    /**
     * The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    public val projectName: Output<String>?
        get() = javaResource.projectName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    public val slsRegionId: Output<String>?
        get() = javaResource.slsRegionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SmartagFlowLogMapper : ResourceMapper<SmartagFlowLog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sag.SmartagFlowLog::class == javaResource::class

    override fun map(javaResource: Resource): SmartagFlowLog = SmartagFlowLog(
        javaResource as
            com.pulumi.alicloud.sag.SmartagFlowLog,
    )
}

/**
 * @see [SmartagFlowLog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SmartagFlowLog].
 */
public suspend fun smartagFlowLog(
    name: String,
    block: suspend SmartagFlowLogResourceBuilder.() -> Unit,
): SmartagFlowLog {
    val builder = SmartagFlowLogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SmartagFlowLog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun smartagFlowLog(name: String): SmartagFlowLog {
    val builder = SmartagFlowLogResourceBuilder()
    builder.name(name)
    return builder.build()
}
