@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin

import com.pulumi.alicloud.sag.SmartagFlowLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Smartag Flow Log resource.
 * For information about Smartag Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createflowlog).
 * > **NOTE:** Available since v1.168.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.sag.SmartagFlowLog("example", {
 *     netflowServerIp: "192.168.0.2",
 *     netflowServerPort: 9995,
 *     netflowVersion: "V9",
 *     outputType: "netflow",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.sag.SmartagFlowLog("example",
 *     netflow_server_ip="192.168.0.2",
 *     netflow_server_port=9995,
 *     netflow_version="V9",
 *     output_type="netflow")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Sag.SmartagFlowLog("example", new()
 *     {
 *         NetflowServerIp = "192.168.0.2",
 *         NetflowServerPort = 9995,
 *         NetflowVersion = "V9",
 *         OutputType = "netflow",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sag"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sag.NewSmartagFlowLog(ctx, "example", &sag.SmartagFlowLogArgs{
 * 			NetflowServerIp:   pulumi.String("192.168.0.2"),
 * 			NetflowServerPort: pulumi.Int(9995),
 * 			NetflowVersion:    pulumi.String("V9"),
 * 			OutputType:        pulumi.String("netflow"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sag.SmartagFlowLog;
 * import com.pulumi.alicloud.sag.SmartagFlowLogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SmartagFlowLog("example", SmartagFlowLogArgs.builder()
 *             .netflowServerIp("192.168.0.2")
 *             .netflowServerPort(9995)
 *             .netflowVersion("V9")
 *             .outputType("netflow")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:sag:SmartagFlowLog
 *     properties:
 *       netflowServerIp: 192.168.0.2
 *       netflowServerPort: 9995
 *       netflowVersion: V9
 *       outputType: netflow
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Smartag Flow Log can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sag/smartagFlowLog:SmartagFlowLog example <id>
 * ```
 * @property activeAging The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
 * @property description The description of the flow log.
 * @property flowLogName The name of the flow log.
 * @property inactiveAging The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
 * @property logstoreName The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
 * @property netflowServerIp The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
 * @property netflowServerPort The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
 * @property netflowVersion The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
 * @property outputType The location where the flow log is stored. Valid values:
 * @property projectName The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
 * @property slsRegionId The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
 * @property status The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
 */
public data class SmartagFlowLogArgs(
    public val activeAging: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val flowLogName: Output<String>? = null,
    public val inactiveAging: Output<Int>? = null,
    public val logstoreName: Output<String>? = null,
    public val netflowServerIp: Output<String>? = null,
    public val netflowServerPort: Output<Int>? = null,
    public val netflowVersion: Output<String>? = null,
    public val outputType: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val slsRegionId: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sag.SmartagFlowLogArgs> {
    override fun toJava(): com.pulumi.alicloud.sag.SmartagFlowLogArgs =
        com.pulumi.alicloud.sag.SmartagFlowLogArgs.builder()
            .activeAging(activeAging?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowLogName(flowLogName?.applyValue({ args0 -> args0 }))
            .inactiveAging(inactiveAging?.applyValue({ args0 -> args0 }))
            .logstoreName(logstoreName?.applyValue({ args0 -> args0 }))
            .netflowServerIp(netflowServerIp?.applyValue({ args0 -> args0 }))
            .netflowServerPort(netflowServerPort?.applyValue({ args0 -> args0 }))
            .netflowVersion(netflowVersion?.applyValue({ args0 -> args0 }))
            .outputType(outputType?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .slsRegionId(slsRegionId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmartagFlowLogArgs].
 */
@PulumiTagMarker
public class SmartagFlowLogArgsBuilder internal constructor() {
    private var activeAging: Output<Int>? = null

    private var description: Output<String>? = null

    private var flowLogName: Output<String>? = null

    private var inactiveAging: Output<Int>? = null

    private var logstoreName: Output<String>? = null

    private var netflowServerIp: Output<String>? = null

    private var netflowServerPort: Output<Int>? = null

    private var netflowVersion: Output<String>? = null

    private var outputType: Output<String>? = null

    private var projectName: Output<String>? = null

    private var slsRegionId: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
     */
    @JvmName("qfouakjktlkclgtf")
    public suspend fun activeAging(`value`: Output<Int>) {
        this.activeAging = value
    }

    /**
     * @param value The description of the flow log.
     */
    @JvmName("yejsosnsfcanexsv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the flow log.
     */
    @JvmName("ldsxdfgtchvegfru")
    public suspend fun flowLogName(`value`: Output<String>) {
        this.flowLogName = value
    }

    /**
     * @param value The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
     */
    @JvmName("krejqgdvcppnckwi")
    public suspend fun inactiveAging(`value`: Output<Int>) {
        this.inactiveAging = value
    }

    /**
     * @param value The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    @JvmName("gddlacvukigvlfvw")
    public suspend fun logstoreName(`value`: Output<String>) {
        this.logstoreName = value
    }

    /**
     * @param value The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    @JvmName("rjewdanxmuhibgpc")
    public suspend fun netflowServerIp(`value`: Output<String>) {
        this.netflowServerIp = value
    }

    /**
     * @param value The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    @JvmName("tqvdfiscdwovwdxs")
    public suspend fun netflowServerPort(`value`: Output<Int>) {
        this.netflowServerPort = value
    }

    /**
     * @param value The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    @JvmName("ttvpfnhrnxlqihyi")
    public suspend fun netflowVersion(`value`: Output<String>) {
        this.netflowVersion = value
    }

    /**
     * @param value The location where the flow log is stored. Valid values:
     */
    @JvmName("ihhhteoijsecdqvx")
    public suspend fun outputType(`value`: Output<String>) {
        this.outputType = value
    }

    /**
     * @param value The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    @JvmName("ktjmdhfqaxxvhpxb")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    @JvmName("uqhhxwiclrtkflse")
    public suspend fun slsRegionId(`value`: Output<String>) {
        this.slsRegionId = value
    }

    /**
     * @param value The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
     */
    @JvmName("rxcaqqppafvkyuaq")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
     */
    @JvmName("wgdtjqmmnefbabiw")
    public suspend fun activeAging(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeAging = mapped
    }

    /**
     * @param value The description of the flow log.
     */
    @JvmName("usrljhppciijselj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the flow log.
     */
    @JvmName("vwasljmcdycrfarp")
    public suspend fun flowLogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogName = mapped
    }

    /**
     * @param value The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
     */
    @JvmName("ngaexmpspjsguaim")
    public suspend fun inactiveAging(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactiveAging = mapped
    }

    /**
     * @param value The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    @JvmName("iegyhcjrgmdmnrgq")
    public suspend fun logstoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstoreName = mapped
    }

    /**
     * @param value The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    @JvmName("occxcvcgiehcnnol")
    public suspend fun netflowServerIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netflowServerIp = mapped
    }

    /**
     * @param value The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    @JvmName("anyrigbvephjqcdc")
    public suspend fun netflowServerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netflowServerPort = mapped
    }

    /**
     * @param value The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
     */
    @JvmName("kmaekaknugmqlhqc")
    public suspend fun netflowVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netflowVersion = mapped
    }

    /**
     * @param value The location where the flow log is stored. Valid values:
     */
    @JvmName("wdjuwaaqjglqfybf")
    public suspend fun outputType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    @JvmName("ugowjwpcphkqgmss")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
     */
    @JvmName("xeoepwijeorgscfw")
    public suspend fun slsRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsRegionId = mapped
    }

    /**
     * @param value The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
     */
    @JvmName("iubmwsdompkdofux")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SmartagFlowLogArgs = SmartagFlowLogArgs(
        activeAging = activeAging,
        description = description,
        flowLogName = flowLogName,
        inactiveAging = inactiveAging,
        logstoreName = logstoreName,
        netflowServerIp = netflowServerIp,
        netflowServerPort = netflowServerPort,
        netflowVersion = netflowVersion,
        outputType = outputType,
        projectName = projectName,
        slsRegionId = slsRegionId,
        status = status,
    )
}
