@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin.inputs

import com.pulumi.alicloud.sag.inputs.GetAclsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAcls.
 * @property ids A list of Sag Acl IDs.
 * @property nameRegex A regex string to filter Sag Acl instances by name.
 * @property outputFile
 */
public data class GetAclsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sag.inputs.GetAclsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.sag.inputs.GetAclsPlainArgs =
        com.pulumi.alicloud.sag.inputs.GetAclsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAclsPlainArgs].
 */
@PulumiTagMarker
public class GetAclsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Sag Acl IDs.
     */
    @JvmName("lnivwulehclployc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Sag Acl IDs.
     */
    @JvmName("jjobspekxffeyxyx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter Sag Acl instances by name.
     */
    @JvmName("cgkoxrglgdqyitrt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgdcgcplprbgscfp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAclsPlainArgs = GetAclsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
