@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sag.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAcls.
 * @property acls A list of Sag Acls. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Sag Acl IDs.
 * @property nameRegex
 * @property names A list of Sag Acls names.
 * @property outputFile
 */
public data class GetAclsResult(
    public val acls: List<GetAclsAcl>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sag.outputs.GetAclsResult): GetAclsResult =
            GetAclsResult(
                acls = javaType.acls().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.sag.kotlin.outputs.GetAclsAcl.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            )
    }
}
